<?php
class ControllerExtensionPaymentOpencart extends Controller 
{
	protected $gatewayUrl = 'https://premuim.rcagpex.com/';
    
    /**
     * Load the hidden form of payment in checkout page
     *
     * @param with order details like order id
     *
     * @return to view with checkout page
     */
    public function index() 
	{
		$this->load->language('extension/payment/opencart');
		$data['button_confirm'] = $this->language->get('button_confirm');
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		if ($order_info) {
			$data['item_name'] = html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8');
			$data['products']  = [];

			foreach ($this->cart->getProducts() as $product) {
				$option_data = [];

				foreach ($product['option'] as $option) {
					if ($option['type'] != 'file') {
						$value = $option['value'];
					} else {
						$upload_info = $this->model_tool_upload->getUploadByCode($option['value']);
                        $value = $upload_info['name'] ?? '';
					}

					$option_data[] = [
						'name'  => $option['name'],
						'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value)
					];
				}

				$data['products'][] = [
					'name'     => htmlspecialchars($product['name']),
					'model'    => htmlspecialchars($product['model']),
					'price'    => $this->currency->format($product['price'], $order_info['currency_code'], false, false),
					'quantity' => $product['quantity'],
					'option'   => $option_data,
					'weight'   => $product['weight']
				];
			}

			$data['discount_amount_cart'] = 0;

			$total = $this->currency->format($order_info['total'] - $this->cart->getSubTotal(), $order_info['currency_code'], false, false);

			if ($total > 0) {
				$data['products'][] = [
					'name'     => $this->language->get('text_total'),
					'model'    => '',
					'price'    => $total,
					'quantity' => 1,
					'option'   => array(),
					'weight'   => 0
				];
			} else {
				$data['discount_amount_cart'] -= $total;
			}
            $data['action'] = $this->url->link('extension/payment/opencart/process');
			$data['custom'] = $this->session->data['order_id'];
			return $this->load->view('extension/payment/opencart', $data);
		}
	}

	/**
	 * Process data after click on checkout confirm
	 *
	 * @param post value
	 *
	 * @return to gateway url to confirm payment
	 */
	public function process() 
	{
        $this->load->model('checkout/order');
        $this->load->language('extension/payment/opencart');

        $orderInfo                = $this->model_checkout_order->getOrder($_POST['custom']);
        $payload['client_id']     = $this->config->get('payment_opencart_merchant_client_id');
        $payload['client_secret'] = $this->config->get('payment_opencart_merchant_secret_key');
        $merchantVerifyDetails    = $this->execute($this->gatewayUrl . 'merchant/api/verify','post' , $payload);
        $merchantVerifyDetails    = json_decode($merchantVerifyDetails);
        $this->document->setTitle($this->language->get('heading_title'));
        
        $data['breadcrumbs']   = [];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        ];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_basket'),
            'href' => $this->url->link('checkout/cart')
        ];
        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_checkout'),
            'href' => $this->url->link('checkout/checkout', '', true)
        ];

        $data['heading_title']  = $this->language->get('heading_title');
        $data['text_message']   = $merchantVerifyDetails->message;
        $data['continue'] 	    = $this->url->link('checkout/checkout');
        $data['column_left']    = $this->load->controller('common/column_left');
        $data['column_right']   = $this->load->controller('common/column_right');
        $data['content_top']    = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer']         = $this->load->controller('common/footer');
        $data['header']         = $this->load->controller('common/header');
        $data['class']          = 'col-sm-12';
        if (isset($merchantVerifyDetails->data->access_token)) {

	        $params['payer']      = $this->language->get('text_title');
	        $params['amount']     = $orderInfo['total'];
	        $params['currency']   = $orderInfo['currency_code'];
	        $params['successUrl'] = $this->url->link('extension/payment/opencart/success&opencart_order_id='.$orderInfo['order_id']);
	        $params['cancelUrl']  = $this->url->link('checkout/checkout');
	        $header 		      = ['Authorization: Bearer ' . $merchantVerifyDetails->data->access_token];

	        $transactionInfo      = $this->execute($this->gatewayUrl . 'merchant/api/transaction-info', 'POST', $params, $header);
	        $transactionInfo      = json_decode($transactionInfo);
	       	$data['text_message'] = $transactionInfo->message;

	        if (isset($transactionInfo->data->approvedUrl)) {
	        	header("Location: " . $transactionInfo->data->approvedUrl);
	        } else {
	      	    return $this->response->setOutput($this->load->view('extension/payment/opencart_error', $data));
	        }
        } else {
        	return $this->response->setOutput($this->load->view('extension/payment/opencart_error', $data));
        }
	}

	/**
	 * Update order details after confirm payment
	 *
	 * @return to checkout success page
	 */
    public function success()
    {
        $this->load->model('checkout/order');
        $this->model_checkout_order->addOrderHistory($this->request->get['opencart_order_id'], $this->config->get('payment_opencart_order_status_id'));
        $this->response->redirect($this->url->link('checkout/success'));
    }
    
    /**
     * Handle all api call
     *
     * @param $url, $method, $payload, $headers=null
     *
     * @return the result of requested api call
     */
    public function execute($url, $method, $payload, $headers=null)
    {
        $ch = curl_init();
        
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => false
        ));

        if( strtoupper($method) == "POST" ) {
            curl_setopt($ch,CURLOPT_POST,true);
            curl_setopt($ch,CURLOPT_POSTFIELDS,$payload);
        }

        if ( $headers != null ) {
            curl_setopt($ch,CURLOPT_HTTPHEADER,$headers);
        }

        $result = curl_exec($ch);
        $info   =  curl_getinfo($ch,CURLINFO_HEADER_OUT);

        return $result;
    }
}